C
C------------------------------------------------------
C
C     Problem:    2LNK_ROB
C
C     Date:       12.02.99
C
C------------------------------------------------------
C
*     REAL CONSTANT
      m1 = 36
      m2 = 36
      l1 = 1
      l2 = 1
      g = 9.81
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      q10, q20, q1, q2, v1, v2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION q1_t
      q1_t = v1
C
*     FUNCTION q2_t
      q2_t = v2
C
*     FUNCTION v1_t
      c1 = cos(q1)
      c2 = cos(q2)
      s2 = sin(q2)
      c12 = cos(q1 + q2)
      m11 = m1*l1**2/3 + m2*(l1**2 + l2**2/3 + l1*l2*c2)
      m12 = m2*(l2**2/3 + l1*l2*c2/2)
      m21 = m12
      m22 = m2*l2**2/3
      f1 = -m1*g*l1*c1/2 - m2*g*(l1*c1 + l2*c12/2) 
     /         + m2*l1*l2*s2/2*(2*v1*v2 + v2**2)
      f2 = -m2*g*l2*c12/2 - m2*l1*l2*s2/2*v1**2
      D = m11*m22 - m12**2
      v1_t =(m11*f2 - m12*f1)/D
C
*     FUNCTION v2_t
      v2_t = (m22*f1 - m12*f2)/D
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION q1_0
      q1_0 = q10
C
*     FUNCTION q2_0
      q2_0 = q20
C
*     FUNCTION v1_0
      v1_0 = 0
C
*     FUNCTION v2_0
      v2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION q1_fit
      q1_fit = q1
C
*     FUNCTION q2_fit
      q2_fit = q2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





