C
C------------------------------------------------------
C
C   Problem:    2LKC_ROB
C
C   Date:       12.02.99
C
C------------------------------------------------------
C
*     REAL CONSTANT
      m1 = 1
      m2 = 1
      l1 = 1
      l2 = 1.1
      m11 = m1
      m22 = m1
      m33 = m1*l1**2/3
      m44 = m2
      m55 = m2
      m66 = m2*l2/3
      f1 = 0.0
      f2 = -9.81
      f3 = 0.0
      f4 = 0.0
      f5 = -9.81
      f6 = 0.0
      q40 = 0
C
C------------------------------------------------------
C      
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      q10, q20, q30, q50, q60
      q1, q2, q3, q4, q5, q6
      qs1, qs2, qs3, qs4, qs5, qs6
      lambda1, lambda2, lambda3, lambda4, lambda5
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION q1_t
      q1_t = qs1
C
*     FUNCTION q2_t
      q2_t = qs2
C
*     FUNCTION q3_t
      q3_t = qs3
C
*     FUNCTION q4_t
      q1_4 = qs4
C
*     FUNCTION q5_t
      q5_t = qs5
C
*     FUNCTION q6_t
      q6_t = qs6
C
*     FUNCTION qs1_t
      g11 = 1
      g12 = 0
      g13 = l1/2*sin(q3)
      g14 = 0
      g15 = 0
      g16 = 0
      g21 = 0
      g22 = 1
      g23 = -l1/2*cos(q3)
      g24 = 0
      g25 = 0
      g26 = 0
      g31 = -2
      g32 = 0
      g33 = 0
      g34 = 1
      g35 = 0
      g36 = l2/2*sin(q6)
      g41 = 0
      g42 = -2
      g43 = 0
      g44 = 0
      g45 = 1
      g46 = -l2/2*cos(q6)
      g51 = 0
      g52 = 0
      g53 = l1*cos(q3)
      g54 = 0
      g55 = 0
      g56 = l2*cos(q6)
C
      qs1_t = (f1 - (g11*lambda1 + g21*lambda2  + g31*lambda3
     /                 + g41*lambda4 + g51*lambda5))/m11
C
*     FUNCTION qs2_t
      qs2_t = (f2 - (g12*lambda1 + g22*lambda2  + g32*lambda3
     /                 + g42*lambda4 + g52*lambda5))/m22
C
*     FUNCTION qs3_t
      qs3_t = (f3 - (g13*lambda1 + g23*lambda2  + g33*lambda3
     /            + g43*lambda4 + g53*lambda5))/m33
C
*     FUNCTION qs4_t
      qs4_t = (f4 - (g14*lambda1 + g24*lambda2  + g34*lambda3
     /            + g44*lambda4 + g54*lambda5))/m44
C
*     FUNCTION qs5_t
      qs5_t = (f5 - (g15*lambda1 + g25*lambda2  + g35*lambda3
     /            + g45*lambda4 + g55*lambda5))/m55
C
*     FUNCTION qs6_t
      qs6_t = (f6 - (g16*lambda1 + g26*lambda2  + g36*lambda3
     /            + g46*lambda4 + g56*lambda5))/m66
C
*     FUNCTION alg_equ1
      qs1t = (f1 - (g11*lambda1 + g21*lambda2  + g31*lambda3
     /                 + g41*lambda4 + g51*lambda5))/m11
      qs2t = (f2 - (g12*lambda1 + g22*lambda2  + g32*lambda3
     /                 + g42*lambda4 + g52*lambda5))/m22
      qs3t = (f3 - (g13*lambda1 + g23*lambda2  + g33*lambda3
     /            + g43*lambda4 + g53*lambda5))/m33
      qs4t = (f4 - (g14*lambda1 + g24*lambda2  + g34*lambda3
     /            + g44*lambda4 + g54*lambda5))/m44
      qs5t = (f5 - (g15*lambda1 + g25*lambda2  + g35*lambda3
     /            + g45*lambda4 + g55*lambda5))/m55
      qs6t = (f6 - (g16*lambda1 + g26*lambda2  + g36*lambda3
     /            + g46*lambda4 + g56*lambda5))/m66
c      alg_equ1 = q1 - l1/2*cos(q3)
      alg_equ1 = qs1t + l1/2*sin(q3)*qs3t + l1/2*cos(q3)*qs3**2
C
*     FUNCTION alg_equ2
c      alg_equ2 = q2 - l1/2*sin(q3)
      alg_equ2 = qs2t - l1/2*cos(q3)*qs3t + l1/2*sin(q3)*qs3**2
C
*     FUNCTION alg_equ3
c      alg_equ3 = q4 - 2*q1 - l2/2*cos(q6)
      alg_equ3 = qs4t - 2*qs1t + l2/2*sin(q6)*qs6t 
     /                                    + l2/2*cos(q6)*qs6**2
C
*     FUNCTION alg_equ4
c      alg_equ4 = q5 - 2*q2 - l2/2*sin(q6)
      alg_equ4 = qs5t - 2*qs2t - l2/2*cos(q6)*qs6t 
     /                                    + l2/2*sin(q6)*qs6**2
C
*     FUNCTION alg_equ5
c      alg_equ5 = l1*sin(q3) + l2*sin(q6)
      alg_equ5 = -l1*sin(q3)*qs3**2 + l1*cos(q3)*qs3t 
     /                    + l2*cos(q6)*qs6t - l2*sin(q6)*qs6**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION q1_0
      q1_0 = q10
C
*     FUNCTION q2_0
      q2_0 = q20
C
*     FUNCTION q3_0
      q3_0 = q30
C
*     FUNCTION q4_0
      q4_0 = q40*100
C
*     FUNCTION q5_0
      q5_0 = q50
C
*     FUNCTION q6_0
      q6_0 = q60
C
*     FUNCTION qs1_0
      qs1_0 = 0
C
*     FUNCTION qs2_0
      qs2_0 = 0
C
*     FUNCTION qs3_0
      qs3_0 = 0
C
*     FUNCTION qs4_0
      qs4_0 = 0
C
*     FUNCTION qs5_0
      qs5_0 = 0
C
*     FUNCTION qs6_0
      qs6_0 = 0
C
*     FUNCTION lambda1_0
      lambda1_0 = 1
C
*     FUNCTION lambda2_0
      lambda2_0 = 1
C
*     FUNCTION lambda3_0
      lambda3_0 = 1
C
*     FUNCTION lambda4_0
      lambda4_0 = 1
C
*     FUNCTION lambda5_0
      lambda5_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION q1_fit
      q1_fit = q1
C
*     FUNCTION q2_fit
      q2_fit = q2
C
*     FUNCTION q5_fit
      q5_fit = q5
C
*     FUNCTION q6_fit
      q6_fit = q6
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
