C
C------------------------------------------------------
C
C     Problem:    2CSTR
C
C     Date:       30.05.2002
C
C------------------------------------------------------
C
*     SPLINE u1
      0.0  -0.3
      0.7   0.1
      1.5   0.02
      2.0   0.0
C
*     SPLINE u2
      0.0   0.1
      0.7   0.25
      1.5   0.1
      2.0   0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      c1, c2, tau, x1, x2, x3, x4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      R1 = (x1 + c1)*exp(25*x2/(x2 + 2))
      f1 = c1 - x1 - R1
      x1_t = f1
C
*     FUNCTION x2_t
      R2 = (x3 + c1)*exp(25*x2/(x4 + 2))
      f2 = -2*(x2 + c2) - u1(t)*(x2 + c2) + R1
      x2_t = f2
C
*     FUNCTION x3_t
      x3_t = x1 - x3 - tau*f1 - R2 + c2
C
*     FUNCTION x4_t
      x4_t = x2 - 2*x4 - u2(t)*(x4 + c2) - tau*f2 + R2 - c2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0.15
C
*     FUNCTION x2_0
      x2_0 = -0.03
C
*     FUNCTION x3_0
      x3_0 = 0.1
C
*     FUNCTION x4_0
      x4_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION u1_ctrl
      u1_ctrl = u1(t)
C
*     FUNCTION u2_ctrl
      u2_ctrl = u2(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C









