C
C------------------------------------------------------
C
C     Problem:    2BODY
C
C     Date:       24.11.2001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, y1, y2, y3, y4, eps, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = y2
C
*     FUNCTION y2_t
      r = y2**2 + y4**2
      y2_t = -a*y1/r**3
C
*     FUNCTION y3_t
      y3_t = y4
C
*     FUNCTION y4_t
      y4_t = -b*y3/r**3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 1 - eps
C
*     FUNCTION y2_0
      y2_0 = 0
C
*     FUNCTION y3_0
      y3_0 = 0
C
*     FUNCTION y4_0
      y4_0 = sqrt((1+eps)/(1-eps))
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y4_fit
      y4_fit = y4
c
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
