C
C------------------------------------------------------
C
C     Problem:    2AREAS_C
C
C     Date:       12.11.98
C
C------------------------------------------------------
C   
*     Real Constant
      Vd=1
      Va=1
C
C------------------------------------------------------
C   
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      m, ya, Da, Db, C, C_x, C_xx, v, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION Ca_t
      Ca_t = Da*C_xx 
C
*     FUNCTION Cb_t
      Cb_t = Db*C_xx 
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION Ca_0
      Ca0=ya/Vd
      Ca_0 = Ca0
C
*     FUNCTION Cb_0
      Cb_0 = 0
C
C------------------------------------------------------
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
c
*     FUNCTION v_t
      v_t = -Db*C_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION v_0
      v_0 = 0
C
C------------------------------------------------------
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION Cb_left
      Cb_left = C/m
C
*     FUNCTION Cb_right
      Cb_right = v/Va
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
*     FUNCTION Ca_x_left
      Ca_x_left = 0
C
C
*     FUNCTION Ca_x_right
      Ca_x_right = Db/Da*C_x
C
C------------------------------------------------------
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = v/Va
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
